"""Simulation package for discrete gauge and Wilson-loop analyses.

This package provides helper modules for building lattices, computing
gauge link variables, measuring Wilson loops and fitting string tensions.

It is intentionally minimal to avoid external dependencies; each module
exposes a single entry point used by the discrete-gauge driver.
"""

__all__ = [
    'build_lattice',
    'compute_Amu',
    'compute_Umu',
    'measure_wilson',
    'plot_results',
    'discrete_gauge',
]